<?php

use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;

return new class extends Component {
    use WithNotifications;

    public string $sendNotificationEmail = '1';

    public string $sendNotificationSms = '1';

    public function mount(TradingSettingsService $settings): void
    {
        $this->sendNotificationEmail = $settings->emailNotificationsEnabled() ? '1' : '0';
        $this->sendNotificationSms = $settings->smsNotificationsEnabled() ? '1' : '0';
    }

    public function save(TradingSettingsService $settings): void
    {
        $validated = $this->validate([
            'sendNotificationEmail' => 'required|in:0,1',
            'sendNotificationSms' => 'required|in:0,1',
        ]);

        $settings->updateNotificationChannels(
            $validated['sendNotificationEmail'] === '1',
            $validated['sendNotificationSms'] === '1',
        );

        $this->notifySuccess(__('Notification settings updated successfully.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/565f488b.blade.php', $data);
    }
}; 