<?php

use App\Models\SecurityOrder;
use App\Models\User;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;

return new class extends Component {
    use WithNotifications;

    public ?User $member = null;

    public function mount(int $id): void
    {
        $this->member = User::query()
            ->with(['wallet', 'portfolioHoldings.security'])
            ->findOrFail($id);
    }

    public function activate(): void
    {
        if (! $this->member) {
            return;
        }

        $this->member->forceFill([
            'is_active' => true,
            'email_verified_at' => $this->member->email_verified_at ?? now(),
        ])->save();
        $this->member->refresh();

        $this->notifySuccess(__('Member account approved and activated.'));
    }

    public function suspend(): void
    {
        if (! $this->member) {
            return;
        }

        $this->member->update(['is_active' => false]);
        $this->member->refresh();

        $this->notifySuccess(__('Member account suspended.'));
    }

    public function getPendingOrdersCountProperty(): int
    {
        if (! $this->member) {
            return 0;
        }

        return SecurityOrder::query()
            ->where('user_id', $this->member->id)
            ->where('status', 'pending')
            ->count();
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/5b5c3201.blade.php', $data);
    }
}; 