<?php

use App\Models\CommunityPost;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Locked;
use Livewire\Component;

return new class extends Component {
    use WithNotifications;

    #[Locked]
    public int $postId;

    public string $title = '';
    public string $body_html = '';
    public bool $is_active = true;
    public ?string $published_at = null;

    public function mount(int $post): void
    {
        $communityPost = CommunityPost::query()->findOrFail($post);

        $this->postId = $communityPost->id;
        $this->title = $communityPost->title;
        $this->body_html = $communityPost->body_html;
        $this->is_active = (bool) $communityPost->is_active;
        $this->published_at = $communityPost->published_at?->format('Y-m-d\\TH:i');
    }

    public function save(): void
    {
        $validated = $this->validate([
            'title' => ['required', 'string', 'max:255'],
            'body_html' => ['required', 'string', 'min:2'],
            'is_active' => ['required', 'boolean'],
            'published_at' => ['nullable', 'date'],
        ]);

        CommunityPost::query()->findOrFail($this->postId)->update([
            'title' => $validated['title'],
            'body_html' => $validated['body_html'],
            'is_active' => $validated['is_active'],
            'published_at' => $validated['published_at'],
        ]);

        $this->notifySuccess(__('Community post updated successfully.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/61b5a440.blade.php', $data);
    }
}; 