<?php

use App\Models\WalletTransaction;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;

return new class extends Component {
    use WithPagination;

    public string $type = 'all';

    public string $status = 'all';

    private const TYPE_LABELS = [
        'deposit_request' => 'Deposit request',
        'mpesa_deposit_request' => 'M-Pesa deposit request',
        'withdrawal_request' => 'Withdrawal request',
        'order_debit' => 'Order debit',
        'order_credit' => 'Order credit',
        'investment_debit' => 'Investment debit',
        'investment_credit' => 'Investment credit',
    ];

    #[Computed]
    public function typeOptions(): array
    {
        return array_keys(self::TYPE_LABELS);
    }

    #[Computed]
    public function transactions()
    {
        return WalletTransaction::query()
            ->with(['user', 'wallet', 'approver'])
            ->when($this->type !== 'all', fn ($query) => $query->where('type', $this->type))
            ->when($this->status !== 'all', fn ($query) => $query->where('status', $this->status))
            ->latest()
            ->paginate(15, ['*'], 'transactions_page');
    }

    public function typeLabel(string $type): string
    {
        return __(self::TYPE_LABELS[$type] ?? ucfirst(str_replace('_', ' ', $type)));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/725d012c.blade.php', $data);
    }
}; 