<?php

use App\Models\CommunityPost;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Livewire\Component;

return new #[Layout('layouts.trading')] class extends Component {
    #[Locked]
    public int $postId;

    public function mount(int $post): void
    {
        $this->postId = $post;
        $this->ensureVisiblePostExists();
    }

    #[Computed]
    public function post(): CommunityPost
    {
        return CommunityPost::query()
            ->published()
            ->with('author:id,name,username')
            ->findOrFail($this->postId);
    }

    private function ensureVisiblePostExists(): void
    {
        CommunityPost::query()->published()->findOrFail($this->postId);
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/8580794e.blade.php', $data);
    }
}; 