<?php

use App\Models\CommunityPost;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;

return new class extends Component {
    use WithNotifications;

    public string $title = '';
    public string $body_html = '';
    public bool $is_active = true;
    public ?string $published_at = null;

    public function save(): void
    {
        $validated = $this->validate([
            'title' => ['required', 'string', 'max:255'],
            'body_html' => ['required', 'string', 'min:2'],
            'is_active' => ['required', 'boolean'],
            'published_at' => ['nullable', 'date'],
        ]);

        CommunityPost::query()->create([
            'user_id' => auth()->id(),
            'title' => $validated['title'],
            'body_html' => $validated['body_html'],
            'is_active' => $validated['is_active'],
            'published_at' => $validated['published_at'] ?: now(),
        ]);

        $this->notifySuccess(__('Community post created successfully.'));

        $this->redirect(route('admin.community.index'), navigate: true);
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/a06ea162.blade.php', $data);
    }
}; 