<?php

use App\Models\SecurityOrder;
use App\Services\Trading\OrderApprovalService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;

return new class extends Component {
    use WithNotifications;
    use WithPagination;

    public string $status = 'pending';

    #[Computed]
    public function orders()
    {
        return SecurityOrder::query()
            ->with(['user', 'security', 'wallet'])
            ->when($this->status !== 'all', fn ($query) => $query->where('status', $this->status))
            ->latest()
            ->paginate(12);
    }

    public function approve(int $orderId): void
    {
        $order = SecurityOrder::query()->with(['user', 'security', 'wallet'])->find($orderId);

        if (! $order) {
            $this->notifyError(__('Order not found.'));

            return;
        }

        try {
            app(OrderApprovalService::class)->approve($order);
            $this->notifySuccess(__('Order approved successfully.'));
        } catch (\RuntimeException $e) {
            $this->notifyError($e->getMessage());
        }
    }

    public function reject(int $orderId): void
    {
        $order = SecurityOrder::query()->with(['user', 'security', 'wallet'])->find($orderId);

        if (! $order) {
            $this->notifyError(__('Order not found.'));

            return;
        }

        try {
            app(OrderApprovalService::class)->reject($order);
            $this->notifySuccess(__('Order rejected and funds released.'));
        } catch (\RuntimeException $e) {
            $this->notifyError($e->getMessage());
        }
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/a5224830.blade.php', $data);
    }
}; 