<?php

use App\Models\SecurityOrder;
use App\Services\Trading\OrderApprovalService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;

return new class extends Component {
    use WithNotifications;
    use WithPagination;

    public string $status = 'all';

    #[Computed]
    public function orderLogs()
    {
        return SecurityOrder::query()
            ->with(['user', 'security', 'approver', 'wallet'])
            ->when($this->status !== 'all', fn ($query) => $query->where('status', $this->status))
            ->latest()
            ->paginate(10, ['*'], 'ordersPage');
    }

    public function approve(int $orderId): void
    {
        $order = SecurityOrder::query()->with(['user', 'security', 'wallet'])->find($orderId);

        if (! $order) {
            $this->notifyError(__('Order not found.'));

            return;
        }

        try {
            app(OrderApprovalService::class)->approve($order);
            $this->notifySuccess(__('Order approved successfully.'));
        } catch (\RuntimeException $e) {
            $this->notifyError($e->getMessage());
        }
    }

    public function reject(int $orderId): void
    {
        $order = SecurityOrder::query()->with(['user', 'security', 'wallet'])->find($orderId);

        if (! $order) {
            $this->notifyError(__('Order not found.'));

            return;
        }

        try {
            app(OrderApprovalService::class)->reject($order);
            $this->notifySuccess(__('Order rejected and funds released.'));
        } catch (\RuntimeException $e) {
            $this->notifyError($e->getMessage());
        }
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/be842df0.blade.php', $data);
    }
}; 