<?php

use App\Models\InvestmentPackage;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;

return new class extends Component {
    use WithNotifications;
    use WithPagination;

    public string $search = '';

    public int $perPage = 10;

    public function updatedSearch(): void
    {
        $this->resetPage();
    }

    public function updatedPerPage(): void
    {
        $this->resetPage();
    }

    #[Computed]
    public function results()
    {
        $query = InvestmentPackage::query();

        if ($this->search !== '') {
            $query->where('name', 'like', '%'.$this->search.'%');
        }

        return $query->orderByDesc('created_at')->paginate($this->perPage, ['*'], 'packages_page');
    }

    public function activate(int $id): void
    {
        $package = InvestmentPackage::query()->find($id);
        if (! $package) {
            $this->notifyError(__('Package not found.'));

            return;
        }
        $package->is_active = true;
        $package->save();
        $this->notifySuccess(__('Package was activated successfully.'));
    }

    public function deactivate(int $id): void
    {
        $package = InvestmentPackage::query()->find($id);
        if (! $package) {
            $this->notifyError(__('Package not found.'));

            return;
        }
        $package->is_active = false;
        $package->save();
        $this->notifySuccess(__('Package was deactivated successfully.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/d4084fe4.blade.php', $data);
    }
}; 