<?php
use App\Models\InvestmentPackage;
use App\Models\WalletTransaction;
use App\Mail\AdminDepositMail;
use App\Mail\SubscriptionCreatedMail;
use App\Mail\WalletTransactionMail;
use App\Services\Investment\SubscriptionService;
use App\Services\Sms\SmsAfrikasTalking;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Wallet Requests') }}</x-slot>
        <x-slot name="desc">{{ __('Approve or reject member deposit and withdrawal requests.') }}</x-slot>

        {!! $this->renderNotification() !!}

        <div class="mb-4">
            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Status Filter') }}</label>
            <select wire:model.live="status"
                class="mt-1 block w-full max-w-xs rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                <option value="pending">{{ __('Pending') }}</option>
                <option value="approved">{{ __('Approved') }}</option>
                <option value="rejected">{{ __('Rejected') }}</option>
                <option value="all">{{ __('All') }}</option>
            </select>
        </div>

        {{-- Deposit requests --}}
        <div class="mb-10">
            <h2 class="text-base font-semibold text-gray-900 dark:text-gray-100 mb-3">{{ __('Deposit Requests') }}</h2>
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Name') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Phone Number') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Amount') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Transaction Code') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Date & Time') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                            <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800">
                        @forelse ($this->depositRequests as $request)
                            <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                                <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ $request->user?->name ?? '-' }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $request->phone_number ?? data_get($request->meta, 'phone_number', $request->user?->phone) ?? '-' }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $request->currency_code }} {{ number_format((float) $request->amount, 2) }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $request->transaction_code ?? data_get($request->meta, 'reference') ?? '-' }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $request->created_at?->format('M j, Y g:i A') ?? '-' }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ ucfirst($request->status) }}</td>
                                <td class="py-4 pr-4 pl-3 text-right">
                                    @if ($request->status === 'pending')
                                        <button type="button" wire:click="approve({{ $request->id }})"
                                            class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500">{{ __('Approve') }}</button>
                                        <button type="button" wire:click="reject({{ $request->id }})"
                                            class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500">{{ __('Reject') }}</button>
                                    @else
                                        <span class="text-xs text-gray-500">{{ __('Processed') }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No deposit requests found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-4">{{ $this->depositRequests->links() }}</div>
        </div>

        {{-- Withdrawal requests --}}
        <div>
            <h2 class="text-base font-semibold text-gray-900 dark:text-gray-100 mb-3">{{ __('Withdrawal Requests') }}</h2>
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Member') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Amount') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                            <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800">
                        @forelse ($this->withdrawalRequests as $request)
                            <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                                <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ $request->user?->name ?? '-' }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $request->currency_code }} {{ number_format((float) $request->amount, 2) }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ ucfirst($request->status) }}</td>
                                <td class="py-4 pr-4 pl-3 text-right">
                                    @if ($request->status === 'pending')
                                        <button type="button" wire:click="approve({{ $request->id }})"
                                            class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500">{{ __('Approve') }}</button>
                                        <button type="button" wire:click="reject({{ $request->id }})"
                                            class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500">{{ __('Reject') }}</button>
                                    @else
                                        <span class="text-xs text-gray-500">{{ __('Processed') }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No withdrawal requests found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-4">{{ $this->withdrawalRequests->links() }}</div>
        </div>
    </x-admin-panel>
</div>