<?php
use App\Facades\Vrm\MediaForge;
use App\Models\InvestmentPackage;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;
use Livewire\WithFileUploads;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Edit Investment Package') }}</x-slot>
        <x-slot name="desc">{{ __('Update package details. Changing min/max or interest does not affect existing subscriptions.') }}</x-slot>
        <x-slot name="button">
            <a href="{{ route('admin.investment-packages.index') }}" wire:navigate
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                {{ __('Go Back') }}
            </a>
        </x-slot>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-5 mb-5 sm:p-6">
            {!! $this->renderNotification() !!}

            <form wire:submit="save" class="space-y-6">
                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Name') }}</label>
                        <input type="text" wire:model="name"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('name') }}</span>
                    </div>
                    <div class="grid grid-cols-2 gap-2">
                        <div>
                            <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Min amount') }}</label>
                            <input type="number" step="0.01" min="0" wire:model="min_amount"
                                class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                            <span class="text-red-500 text-sm">{{ $errors->first('min_amount') }}</span>
                        </div>
                        <div>
                            <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Max amount') }}</label>
                            <input type="number" step="0.01" min="0" wire:model="max_amount"
                                class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                            <span class="text-red-500 text-sm">{{ $errors->first('max_amount') }}</span>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Interest (%)') }}</label>
                        <input type="number" step="0.01" min="0" wire:model="interest_percent"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('interest_percent') }}</span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Duration (hours)') }}</label>
                        <input type="number" min="1" wire:model="duration_hours"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('duration_hours') }}</span>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Description') }}</label>
                    <textarea wire:model="description" rows="3"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6"></textarea>
                    <span class="text-red-500 text-sm">{{ $errors->first('description') }}</span>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Photo (leave empty to keep current)') }}</label>
                        <input type="file" wire:model="photo" accept=".jpg,.jpeg,.png,.webp"
                            class="mt-1 block w-full cursor-pointer px-3 py-2 text-sm file:mr-4 file:rounded-md file:border-0 file:bg-gray-200 dark:file:bg-gray-600 file:px-3 file:py-1.5 file:text-sm file:font-semibold file:text-gray-900 dark:file:text-gray-100" />
                        <span class="text-red-500 text-sm">{{ $errors->first('photo') }}</span>
                        @if ($photo)
                            <img src="{{ $photo->temporaryUrl() }}" class="mt-2 h-24 w-24 rounded object-cover" alt="Preview" />
                        @endif
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Currency code') }}</label>
                        <input type="text" wire:model="currency_code" maxlength="3" placeholder="e.g. USD"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('currency_code') }}</span>
                    </div>
                </div>

                <div class="flex items-center gap-2">
                    <input type="checkbox" wire:model="is_active" id="is_active" class="rounded border-gray-300 dark:border-gray-600" />
                    <label for="is_active" class="text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Active (visible to members)') }}</label>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white hover:bg-indigo-500">
                        {{ __('Update Package') }}
                    </button>
                </div>
            </form>
        </div>
    </x-admin-panel>
</div>