<?php
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Investment Settings') }}</x-slot>
        <x-slot name="desc">{{ __('Control market availability and withdrawal limits (minimum and maximum).') }}</x-slot>

        {!! $this->renderNotification() !!}

        <form wire:submit="save" class="space-y-6 max-w-2xl">
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <div class="bg-white dark:bg-gray-800 px-4 py-5 sm:p-6 space-y-4">
                    <div>
                        <label for="marketOpen" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Market Status') }}</label>
                        <select id="marketOpen" wire:model="marketOpen"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                            <option value="1">{{ __('Open') }}</option>
                            <option value="0">{{ __('Closed') }}</option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('When closed, members cannot place trade orders.') }}</p>
                        @error('marketOpen')
                            <span class="text-red-500 text-xs">{{ $message }}</span>
                        @enderror
                    </div>

                    <div>
                        <p class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-100">{{ __('M-Pesa Withdrawal Limits') }}</p>
                        <div class="mt-2 space-y-3">
                            <div>
                                <label for="mpesaWithdrawalMinAmount" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Minimum amount') }}</label>
                                <input id="mpesaWithdrawalMinAmount" type="number" step="0.01" min="10" wire:model="mpesaWithdrawalMinAmount"
                                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                                @error('mpesaWithdrawalMinAmount')
                                    <span class="text-red-500 text-xs">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="mpesaWithdrawalMaxAmount" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Maximum amount') }}</label>
                                <input id="mpesaWithdrawalMaxAmount" type="number" step="0.01" min="0" wire:model="mpesaWithdrawalMaxAmount"
                                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('Use 0 for no maximum.') }}</p>
                                @error('mpesaWithdrawalMaxAmount')
                                    <span class="text-red-500 text-xs">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div>
                        <p class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-100">{{ __('Bank Withdrawal Limits') }}</p>
                        <div class="mt-2 space-y-3">
                            <div>
                                <label for="bankWithdrawalMinAmount" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Minimum amount') }}</label>
                                <input id="bankWithdrawalMinAmount" type="number" step="0.01" min="10" wire:model="bankWithdrawalMinAmount"
                                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                                @error('bankWithdrawalMinAmount')
                                    <span class="text-red-500 text-xs">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="bankWithdrawalMaxAmount" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Maximum amount') }}</label>
                                <input id="bankWithdrawalMaxAmount" type="number" step="0.01" min="0" wire:model="bankWithdrawalMaxAmount"
                                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('Use 0 for no maximum.') }}</p>
                                @error('bankWithdrawalMaxAmount')
                                    <span class="text-red-500 text-xs">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">{{ __('System minimum for any withdrawal is 100.') }}</p>
                    </div>
                </div>
            </div>

            <button type="submit"
                class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
                {{ __('Save Settings') }}
            </button>
        </form>
    </x-admin-panel>
</div>