<?php
use App\Models\User;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Members') }}</x-slot>
        <x-slot name="desc">{{ __('Manage member accounts, review status, and open account details.') }}</x-slot>

        <div class="my-4">
            <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">{{ __('Search members') }}</h3>
                    <div class="mt-3 w-full sm:max-w-xs">
                        <input type="text" wire:model.live.debounce.300ms="search"
                            class="block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"
                            placeholder="{{ __('Search by name or email...') }}" />
                    </div>
                </div>
            </div>
        </div>

        {!! $this->renderNotification() !!}

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">#</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Member') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Joined') }}</th>
                        <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    @forelse ($this->members as $member)
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ $member->id }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                <p class="font-semibold">{{ $member->name }}</p>
                                <p class="text-xs text-gray-500">{{ $member->email }}</p>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                <span class="px-2 py-0.5 text-xs font-semibold rounded-sm {{ $member->is_active ? 'bg-green-500 text-white' : 'bg-red-500 text-white' }}">
                                    {{ $member->is_active ? __('Active') : __('Suspended') }}
                                </span>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-500 dark:text-gray-400">{{ $member->created_at?->format('Y-m-d') }}</td>
                            <td class="py-4 pr-4 pl-3 text-right space-x-2">
                                <a href="{{ route('admin.members.edit', $member->id) }}"
                                    class="inline-flex items-center rounded-md bg-indigo-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-indigo-500">
                                    {{ __('Edit') }}
                                </a>
                                @if ($member->is_active)
                                    <button type="button" wire:click="suspend({{ $member->id }})"
                                        class="inline-flex items-center rounded-md bg-yellow-500 px-2.5 py-1 text-xs font-semibold text-white hover:bg-yellow-400">
                                        {{ __('Suspend') }}
                                    </button>
                                @else
                                    <button type="button" wire:click="activate({{ $member->id }})"
                                        class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500">
                                        {{ __('Activate') }}
                                    </button>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No members found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-8">{{ $this->members->links() }}</div>
    </x-admin-panel>
</div>