<?php
use App\Models\SecurityOrder;
use App\Models\User;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Edit Member') }}</x-slot>
        <x-slot name="desc">{{ __('Review profile, wallet, and portfolio details for this member.') }}</x-slot>
        <x-slot name="button">
            <a href="{{ route('admin.members.index') }}"
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                {{ __('Go Back') }}
            </a>
        </x-slot>

        {!! $this->renderNotification() !!}

        @if ($member)
            <div class="space-y-4">
                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-lg font-semibold text-gray-900 dark:text-gray-100">{{ $member->name }}</p>
                    <p class="text-sm text-gray-500">{{ $member->email }}</p>
                    <p class="mt-2 text-sm text-gray-700 dark:text-gray-300">{{ __('Pending Orders') }}: {{ $this->pendingOrdersCount }}</p>
                    <div class="mt-4 flex gap-3">
                        @if ($member->is_active)
                            <button type="button" wire:click="suspend"
                                class="rounded-md bg-yellow-500 px-4 py-2 text-sm font-semibold text-white hover:bg-yellow-400">{{ __('Suspend Account') }}</button>
                        @else
                            <button type="button" wire:click="activate"
                                class="rounded-md bg-green-600 px-4 py-2 text-sm font-semibold text-white hover:bg-green-500">{{ __('Activate Account') }}</button>
                        @endif
                    </div>
                </div>

                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Wallet') }}</p>
                    <div class="mt-2 grid gap-2 text-sm text-gray-700 dark:text-gray-300">
                        <p>{{ __('Currency') }}: {{ $member->wallet ? app(\App\Services\DefaultCurrencyService::class)->code() : '-' }}</p>
                        <p>{{ __('Balance') }}: {{ number_format((float) ($member->wallet?->balance ?? 0), 2) }}</p>
                        <p>{{ __('Used') }}: {{ number_format((float) ($member->wallet?->used_amount ?? 0), 2) }}</p>
                        <p>{{ __('Earned') }}: {{ number_format((float) ($member->wallet?->earned_amount ?? 0), 2) }}</p>
                    </div>
                </div>

                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Portfolio Holdings') }}</p>
                    <div class="mt-3 space-y-2">
                        @forelse ($member->portfolioHoldings as $holding)
                            <div class="flex items-center justify-between rounded-md border border-gray-200 px-3 py-2 dark:border-gray-700">
                                <p class="text-sm text-gray-900 dark:text-gray-100">{{ $holding->security?->trading_name }}</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">{{ __('Qty') }}: {{ $holding->quantity }}</p>
                            </div>
                        @empty
                            <p class="text-sm text-gray-500">{{ __('No holdings yet.') }}</p>
                        @endforelse
                    </div>
                </div>
            </div>
        @endif
    </x-admin-panel>
</div>