<?php
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Notifications Settings') }}</x-slot>
        <x-slot name="desc">{{ __('Control whether system notifications are sent through Email and SMS.') }}</x-slot>

        {!! $this->renderNotification() !!}

        <form wire:submit="save" class="space-y-6 max-w-2xl">
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <div class="bg-white dark:bg-gray-800 px-4 py-5 sm:p-6 space-y-4">
                    <div>
                        <label for="sendNotificationEmail" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Send Notification via Email') }}</label>
                        <select id="sendNotificationEmail" wire:model="sendNotificationEmail"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                            <option value="1">{{ __('On') }}</option>
                            <option value="0">{{ __('Off') }}</option>
                        </select>
                        @error('sendNotificationEmail')
                            <span class="text-red-500 text-xs">{{ $message }}</span>
                        @enderror
                    </div>

                    <div>
                        <label for="sendNotificationSms" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Send Notification via SMS') }}</label>
                        <select id="sendNotificationSms" wire:model="sendNotificationSms"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                            <option value="1">{{ __('On') }}</option>
                            <option value="0">{{ __('Off') }}</option>
                        </select>
                        @error('sendNotificationSms')
                            <span class="text-red-500 text-xs">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

            <details class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <summary class="bg-white dark:bg-gray-800 px-4 py-3 cursor-pointer text-sm font-medium text-gray-900 dark:text-gray-100 hover:bg-gray-50 dark:hover:bg-gray-700">
                    {{ __('Per-type notification settings') }}
                </summary>
                <div class="border-t border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-800 px-4 py-5 sm:p-6 space-y-4">
                    <p class="text-sm text-gray-500 dark:text-gray-400">{{ __('Control each notification type individually. Global toggles above must be On for any notifications to be sent.') }}</p>
                    <div class="grid gap-4 sm:grid-cols-2">
                        @foreach ($this->granularRows() as $row)
                            <div class="rounded-lg border border-gray-200 dark:border-gray-600 p-4 space-y-3">
                                <h4 class="text-sm font-medium text-gray-900 dark:text-gray-100">{{ $row['label'] }}</h4>
                                <div class="flex gap-4">
                                    <div class="flex-1">
                                        <label for="{{ $row['sms_id'] }}" class="block text-xs text-gray-500 dark:text-gray-400">{{ __('SMS') }}</label>
                                        <select id="{{ $row['sms_id'] }}" wire:model="{{ $row['sms_prop'] }}"
                                            class="mt-0.5 block w-full rounded-md bg-white dark:bg-gray-700 px-2 py-1 text-sm text-gray-900 dark:text-gray-100">
                                            <option value="1">{{ __('On') }}</option>
                                            <option value="0">{{ __('Off') }}</option>
                                        </select>
                                    </div>
                                    <div class="flex-1">
                                        <label for="{{ $row['email_id'] }}" class="block text-xs text-gray-500 dark:text-gray-400">{{ __('Email') }}</label>
                                        <select id="{{ $row['email_id'] }}" wire:model="{{ $row['email_prop'] }}"
                                            class="mt-0.5 block w-full rounded-md bg-white dark:bg-gray-700 px-2 py-1 text-sm text-gray-900 dark:text-gray-100">
                                            <option value="1">{{ __('On') }}</option>
                                            <option value="0">{{ __('Off') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </details>

            <button type="submit"
                class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
                {{ __('Save Settings') }}
            </button>
        </form>
    </x-admin-panel>
</div>