<?php
use App\Models\WalletTransaction;
use App\Services\ReceiptPdfService;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <div class="mx-auto flex max-w-[420px] flex-wrap items-center justify-center gap-3 px-4 pb-4">
        <a
            href="{{ route('member.transactions') }}"
            wire:navigate
            class="inline-flex items-center gap-2 rounded-lg border border-border bg-card px-4 py-2.5 text-sm font-semibold text-foreground shadow-sm hover:bg-muted/60"
        >
            <i class="fa-solid fa-arrow-left" aria-hidden="true"></i>
            {{ __('Back') }}
        </a>
        <a
            href="{{ route('member.transactions.receipt.download', ['transaction' => $transactionId]) }}"
            class="inline-flex items-center gap-2 rounded-lg bg-primary px-4 py-2.5 text-sm font-semibold text-primary-foreground shadow-sm hover:opacity-90"
        >
            <i class="fa-solid fa-file-pdf" aria-hidden="true"></i>
            {{ __('Download PDF') }}
        </a>
    </div>

    @include('partials.receipts.receipt', ['receipt' => $receipt])
</div>