<?php
use App\Models\NotificationState;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    @include('partials.trading.topbar', ['title' => __('Notifications')])

    <div class="space-y-4 px-4 py-4">
        <div class="flex items-center gap-2">
            <button type="button" wire:click="$set('status', 'all')"
                class="rounded-full px-4 py-2 text-sm font-semibold transition {{ $status === 'all' ? 'bg-primary text-primary-foreground' : 'bg-muted text-muted-foreground' }}">
                {{ __('All') }}
            </button>
            <button type="button" wire:click="$set('status', 'unread')"
                class="rounded-full px-4 py-2 text-sm font-semibold transition {{ $status === 'unread' ? 'bg-primary text-primary-foreground' : 'bg-muted text-muted-foreground' }}">
                {{ __('Unread') }}
                @if ($this->unreadCount > 0)
                    <span class="ml-1 text-xs">({{ $this->unreadCount }})</span>
                @endif
            </button>
            <button type="button" wire:click="$set('status', 'read')"
                class="rounded-full px-4 py-2 text-sm font-semibold transition {{ $status === 'read' ? 'bg-primary text-primary-foreground' : 'bg-muted text-muted-foreground' }}">
                {{ __('Read') }}
                @if ($this->readCount > 0)
                    <span class="ml-1 text-xs">({{ $this->readCount }})</span>
                @endif
            </button>
        </div>

        <div>
            <label for="notifications-search" class="sr-only">{{ __('Search notifications') }}</label>
            <div class="relative">
                <input id="notifications-search"
                    type="text"
                    wire:model.live.debounce.400ms="search"
                    placeholder="{{ __('Search name or number') }}"
                    class="w-full rounded-full border border-border bg-card py-3 pl-4 pr-11 text-sm text-foreground placeholder:text-muted-foreground focus:border-primary focus:outline-none focus:ring-2 focus:ring-primary/20" />
                <i class="fa-solid fa-magnifying-glass pointer-events-none absolute right-4 top-1/2 -translate-y-1/2 text-muted-foreground"></i>
            </div>
        </div>

        <div class="flex items-center justify-between gap-3">
            <p class="text-base font-bold text-foreground">{{ __('All Notifications') }}</p>
            <button type="button" wire:click="markAllAsRead"
                class="text-sm font-semibold text-primary transition hover:opacity-80">
                {{ __('Mark as Read') }}
            </button>
        </div>

        @if ($selectedStateIds !== [])
            <div class="rounded-xl border border-border bg-card p-3">
                <button type="button" wire:click="markSelectedAsRead"
                    class="inline-flex items-center gap-2 rounded-lg bg-primary px-3 py-2 text-xs font-semibold text-primary-foreground transition hover:opacity-90">
                    <i class="fa-solid fa-check"></i>
                    {{ __('Mark selected as read') }}
                </button>
            </div>
        @endif

        <div class="overflow-hidden rounded-2xl border border-border bg-card">
            @forelse ($this->notifications as $state)
                @php
                    $title = (string) $state->notification->title;
                    $initials = collect(preg_split('/\s+/', trim($title)) ?: [])->filter()->take(2)->map(fn(string $part): string => strtoupper(substr($part, 0, 1)))->implode('');
                    $initials = $initials !== '' ? $initials : 'NT';
                @endphp
                <div wire:key="notification-state-{{ $state->id }}"
                    class="flex items-start gap-3 border-b border-border px-3 py-3 last:border-b-0 {{ is_null($state->read_at) ? 'bg-muted/35' : '' }}">
                    <div class="relative mt-1 inline-flex h-11 w-11 shrink-0 items-center justify-center rounded-full bg-muted text-base font-semibold text-foreground">
                        {{ $initials }}
                        @if (is_null($state->read_at))
                            <span class="absolute right-0 top-0 h-2.5 w-2.5 rounded-full bg-destructive"></span>
                        @endif
                    </div>

                    <div class="min-w-0 flex-1">
                        <div class="flex items-start justify-between gap-2">
                            <p class="truncate text-base font-semibold text-foreground">{{ $state->notification->title }}</p>
                            <p class="shrink-0 text-xs text-muted-foreground">{{ $state->notification->created_at?->format('d/m/y H:i') }}</p>
                        </div>

                        <p class="mt-1 line-clamp-2 text-sm text-muted-foreground">{{ $state->notification->body }}</p>

                        <div class="mt-2 flex items-center gap-2">
                            @if (is_null($state->read_at))
                                <button type="button" wire:click="markAsRead({{ $state->id }})"
                                    class="rounded-md border border-border px-2.5 py-1 text-xs font-semibold text-primary transition hover:bg-muted">
                                    {{ __('Mark read') }}
                                </button>
                            @endif

                            @if ($state->notification->action_url)
                                <a href="{{ $state->notification->action_url }}" wire:navigate
                                    class="rounded-md border border-border px-2.5 py-1 text-xs font-semibold text-foreground transition hover:bg-muted">
                                    {{ __('Open') }}
                                </a>
                            @endif
                        </div>
                    </div>

                    <label for="notification-state-{{ $state->id }}" class="mt-1 inline-flex items-center">
                        <input id="notification-state-{{ $state->id }}"
                            type="checkbox"
                            wire:model="selectedStateIds"
                            value="{{ $state->id }}"
                            class="h-5 w-5 rounded border-border text-primary focus:ring-primary/30" />
                    </label>
                </div>
            @empty
                <div class="px-4 py-8 text-center text-sm text-muted-foreground">
                    {{ __('No notifications found.') }}
                </div>
            @endforelse
        </div>

        @if ($this->notifications->hasPages())
            <div>
                {{ $this->notifications->links() }}
            </div>
        @endif
    </div>
</div>