<?php
use App\Models\SecurityOrder;
use App\Services\Trading\OrderApprovalService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Trade Logs') }}</x-slot>
        <x-slot name="desc">{{ __('View all member trade orders. Approve or reject pending orders.') }}</x-slot>

        {!! $this->renderNotification() !!}

        <div class="mb-4">
            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Trade Status Filter') }}</label>
            <select wire:model.live="status"
                class="mt-1 block w-full max-w-xs rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                <option value="all">{{ __('All') }}</option>
                <option value="pending">{{ __('Pending') }}</option>
                <option value="approved">{{ __('Approved') }}</option>
                <option value="rejected">{{ __('Rejected') }}</option>
            </select>
        </div>

        <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100 mb-2">{{ __('Trade Orders') }}</h3>
        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Member') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Security') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Type') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Qty') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Amount') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Processed By') }}</th>
                        <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    @forelse ($this->orderLogs as $log)
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ $log->user?->name }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $log->security?->trading_name }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                <span @class([
                                    'inline-flex items-center rounded-full px-2 py-0.5 text-xs font-semibold',
                                    'bg-red-100 text-red-700 dark:bg-red-900/30 dark:text-red-200' => strtolower((string) $log->order_type) === 'sell',
                                    'bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-200' => strtolower((string) $log->order_type) !== 'sell',
                                ])>
                                    {{ strtoupper((string) $log->order_type) }}
                                </span>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $log->quantity }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $log->currency_code }} {{ number_format((float) $log->total_amount, 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ ucfirst($log->status) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-500 dark:text-gray-400">{{ $log->approver?->name ?? '-' }}</td>
                            <td class="py-4 pr-4 pl-3 text-right">
                                @if ($log->status === 'pending')
                                    <button type="button" wire:click="$js.approveTradeLog({{ $log->id }})"
                                        class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500">{{ __('Approve') }}</button>
                                    <button type="button" wire:click="$js.rejectTradeLog({{ $log->id }})"
                                        class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500">{{ __('Reject') }}</button>
                                @else
                                    <span class="text-xs text-gray-500">{{ __('Processed') }}</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No trade logs found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-4">{{ $this->orderLogs->links() }}</div>
    </x-admin-panel>

    @script
        <script>
            $js('approveTradeLog', async (orderId) => {
                const result = await Swal.fire({
                    title: 'Are you sure you want to approve this order?',
                    icon: 'question',
                    showCancelButton: true,
                });

                if (result.isConfirmed) {
                    $wire.approve(orderId);
                }
            });

            $js('rejectTradeLog', async (orderId) => {
                const result = await Swal.fire({
                    title: 'Are you sure you want to reject this order?',
                    icon: 'warning',
                    showCancelButton: true,
                });

                if (result.isConfirmed) {
                    $wire.reject(orderId);
                }
            });
        </script>
    @endscript
</div>