<?php
use Livewire\Attributes\Computed;
use Livewire\Component;
?>

<div class="flex items-center gap-1 rounded-lg border border-border bg-muted/30 p-0.5">
    <button type="button"
        wire:click="setTheme('light')"
        class="inline-flex h-8 w-8 items-center justify-center rounded-md text-sm transition-colors {{ $this->theme === 'light' ? 'bg-background text-foreground shadow-sm' : 'text-muted-foreground hover:text-foreground' }}"
        aria-label="{{ __('Light mode') }}">
        <i class="fa-solid fa-sun h-4 w-4"></i>
    </button>
    <button type="button"
        wire:click="setTheme('dark')"
        class="inline-flex h-8 w-8 items-center justify-center rounded-md text-sm transition-colors {{ $this->theme === 'dark' ? 'bg-background text-foreground shadow-sm' : 'text-muted-foreground hover:text-foreground' }}"
        aria-label="{{ __('Dark mode') }}">
        <i class="fa-solid fa-moon h-4 w-4"></i>
    </button>
</div>