<?php
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Mail\WalletTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\MemberNotificationService;
use App\Services\Sms\SmsNotifier;
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Sleep;
use Illuminate\Validation\ValidationException;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	@include('partials.trading.topbar', ['title' => 'WITHDRAW'])

	<div class="px-4 py-4 space-y-4">
		@if (!empty($this->finalToast))
			<div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
				x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
				x-transition:leave="transform transition ease-in duration-200"
				x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
				x-init="setTimeout(() => {
    show = false;
    $wire.clearFinalToast();
}, 3500)"
				class="fixed inset-x-0 bottom-24 z-[97] px-4 lg:bottom-6">
				<div class="toast relative mx-auto w-full max-w-sm overflow-hidden rounded-lg border border-green-300"
					role="alert" aria-live="assertive" aria-atomic="true">
					<div class="toast-header flex items-center justify-between gap-2 bg-green-50 px-2.5 py-1.5 text-green-800">
						<div class="flex items-center gap-2">
							<span
								class="inline-flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-green-100 text-green-700">✓</span>
							<strong class="mr-auto text-xs font-semibold">{{ $this->finalToast['title'] }}</strong>
						</div>
					</div>
					<div class="toast-body border-t border-green-300 bg-green-50 px-2.5 py-2 text-xs text-green-800">
						{{ $this->finalToast['description'] }}
					</div>
				</div>
			</div>
		@endif

		@if (!empty($this->notification))
			<div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
				x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
				x-transition:leave="transform transition ease-in duration-200"
				x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
				x-init="setTimeout(() => {
    show = false;
    $wire.clearNotification();
}, 3500)"
				class="fixed inset-x-0 bottom-24 z-[96] px-4 lg:bottom-6 [&_.toast]:mx-auto [&_.toast]:max-w-sm [&_.toast]:w-full">
				{!! $this->renderNotification() !!}
			</div>
		@endif

		@if ($step === 'method')
			<div class="space-y-4">
				<button type="button" wire:click="selectMethod('mpesa')"
					class="relative w-full rounded-2xl border p-4 text-left transition-colors {{ $selectedMethod === 'mpesa' ? 'border-primary bg-primary/10' : 'border-border bg-card' }}">
					<span
						class="absolute right-3 top-2 rounded-full bg-sky-500 px-3 py-0.5 text-xs font-semibold text-white">{{ __('Instant') }}</span>
					<div class="flex items-start gap-3">
						<div class="size-8 rounded-xl bg-secondary flex items-center justify-center text-muted-foreground">
							<i class="fa-solid fa-mobile-screen-button"></i>
						</div>
						<div>
							<p class="text-sm font-semibold text-foreground">{{ __('M-Pesa') }}</p>
							<p class="text-sm text-muted-foreground">{{ __('Instant mobile money withdrawal for Kenya users') }}</p>
						</div>
					</div>
				</button>

				<button type="button" wire:click="selectMethod('bank')"
					class="w-full rounded-2xl border p-4 text-left transition-colors {{ $selectedMethod === 'bank' ? 'border-primary bg-primary/10' : 'border-border bg-card' }}">
					<div class="flex items-start gap-3">
						<div class="size-8 rounded-xl bg-secondary flex items-center justify-center text-muted-foreground">
							<i class="fa-solid fa-building-columns"></i>
						</div>
						<div>
							<p class="text-sm font-semibold text-foreground">{{ __('Bank Transfer') }}</p>
							<p class="text-sm text-muted-foreground">{{ __('Direct bank wire transfer for larger withdrawals') }}</p>
						</div>
					</div>
				</button>

				<div class="rounded-2xl border border-border bg-card p-4">
					<p class="mb-3 text-sm font-semibold text-foreground">{{ __('Why withdraw with us?') }}</p>
					<ul class="space-y-2 text-sm text-green-600">
						<li class="flex items-center gap-2"><span>•</span><span>{{ __('Fast processing within 15 minutes') }}</span></li>
						<li class="flex items-center gap-2"><span>•</span><span>{{ __('Low withdrawal fees') }}</span></li>
						<li class="flex items-center gap-2"><span>•</span><span>{{ __('24/7 customer support') }}</span></li>
						<li class="flex items-center gap-2"><span>•</span><span>{{ __('Bank-grade security encryption') }}</span></li>
					</ul>
				</div>

				<button type="button" wire:click="proceedToDetails"
					class="w-full rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-white disabled:opacity-50"
					@disabled($selectedMethod === '')>
					{{ __('Continue to Details') }}
				</button>
			</div>
		@elseif ($step === 'details')
			<div class="bg-card rounded-2xl border border-border p-4 space-y-4">
				<div class="flex items-center gap-6 text-muted-foreground">
					<span class="inline-flex items-center gap-1 text-green-600"><i
							class="fa-solid fa-shield"></i>{{ __('Secure Withdrawals') }}</span>
					<span class="inline-flex items-center gap-1 text-amber-500"><i
							class="fa-solid fa-bolt"></i>{{ __('Fast Processing') }}</span>
				</div>

				<div>
					<label
						class="mb-2 block text-sm font-medium text-foreground">{{ __('Withdrawal Amount (:currency)', ['currency' => $this->currencyCode]) }}</label>
					<input type="number" step="0.01" min="0.01" wire:model.live.debounce.300ms="withdrawAmount"
						class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm" placeholder="0.00" />
					<p class="mt-1 text-xs text-muted-foreground">
						{{ __('Min :min • Max :max', ['min' => number_format($this->withdrawalLimits['min'], 2), 'max' => $this->withdrawalLimits['max'] > 0 ? number_format($this->withdrawalLimits['max'], 2) : __('No limit')]) }}
					</p>
					<p class="mt-1 text-xs text-muted-foreground">
						{{ __('Available balance: :currency :amount', ['currency' => $this->currencyCode, 'amount' => number_format($this->wallet->available_balance, 2)]) }}
					</p>
					<span class="text-destructive text-xs">{{ $errors->first('withdrawAmount') }}</span>
				</div>

				@if ($selectedMethod === 'mpesa')
					<div>
						<label class="mb-2 block text-sm font-medium text-foreground">{{ __('M-Pesa Phone Number') }}</label>
						<input type="text" wire:model="mpesaPhone"
							maxlength="13"
							class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm" placeholder="0712345678 / 0112345678 / 254712345678" />
						<span class="text-destructive text-xs">{{ $errors->first('mpesaPhone') }}</span>
					</div>
				@endif

				@if ($selectedMethod === 'bank')
					<div class="space-y-4">
						<div>
							<label class="mb-2 block text-sm font-medium text-foreground">{{ __('Bank Name') }}</label>
							<input type="text" wire:model="bankName"
								class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm"
								placeholder="{{ __('Enter bank name') }}" />
							<span class="text-destructive text-xs">{{ $errors->first('bankName') }}</span>
						</div>
						<div>
							<label class="mb-2 block text-sm font-medium text-foreground">{{ __('Account Number') }}</label>
							<div x-data="{ showAccount: false }" class="relative">
								<input :type="showAccount ? 'text' : 'password'" wire:model="bankAccountNumber"
									class="w-full rounded-xl border border-border bg-background px-4 py-2.5 pr-12 text-sm"
									placeholder="{{ __('Enter account number') }}" />
								<button type="button" @click="showAccount = !showAccount"
									class="absolute right-4 top-1/2 -translate-y-1/2 text-muted-foreground"
									aria-label="{{ __('Toggle account number visibility') }}">
									<i :class="showAccount ? 'fa-solid fa-eye-slash' : 'fa-solid fa-eye'"></i>
								</button>
							</div>
							<span class="text-destructive text-xs">{{ $errors->first('bankAccountNumber') }}</span>
						</div>
						<div>
							<label class="mb-2 block text-sm font-medium text-foreground">{{ __('Account Holder Name') }}</label>
							<input type="text" wire:model="bankAccountHolderName"
								class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm"
								placeholder="{{ __('Enter account holder name') }}" />
							<span class="text-destructive text-xs">{{ $errors->first('bankAccountHolderName') }}</span>
						</div>
					</div>
				@endif

				<div class="flex gap-2">
					<button type="button" wire:click="backToMethods"
						class="flex-1 rounded-xl border border-border bg-background px-4 py-2.5 text-sm font-semibold text-foreground">
						{{ __('Back') }}
					</button>
					<button type="button" wire:click="goToConfirmation"
						class="flex-1 rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-white disabled:opacity-50"
						@disabled($errors->has('withdrawAmount'))>
						{{ __('Continue to Confirmation') }}
					</button>
				</div>
			</div>
		@elseif ($step === 'confirm')
			@if ($selectedMethod === 'mpesa')
				<div class="min-h-[72vh] flex flex-col gap-6">
					<div class="rounded-3xl border border-border bg-card p-5 space-y-6">
						<div class="mx-auto size-12 rounded-full bg-[#2CB34A] text-white flex items-center justify-center">
							<i class="fa-solid fa-arrow-up-right-dots text-xl"></i>
						</div>

						<p class="text-center text-md font-bold tracking-wide text-foreground">{{ __('WITHDRAW TO M-PESA') }}</p>

						<div class="space-y-6">
							<div>
								<p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground">{{ __('Send Money From') }}
								</p>
								<p class="text-md font-bold text-foreground">{{ __('ZIIDI') }}</p>
							</div>
							<div>
								<p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground">{{ __('Send Money To') }}
								</p>
								<p class="text-md font-bold text-foreground">{{ __('M-PESA') }}</p>
							</div>
							<div class="flex items-end justify-between gap-3">
								<div>
									<p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground">{{ __('Amount') }}</p>
									<p class="text-md font-bold text-foreground">{{ $this->currencyCode }}
										{{ number_format((float) $withdrawAmount, 2) }}</p>
									<p class="text-[11px] uppercase tracking-wide text-muted-foreground">{{ __('Transaction Fee: KSH. 0') }}</p>
								</div>
								<button type="button" wire:click="backToDetails"
									class="inline-flex size-10 items-center justify-center rounded-full bg-secondary text-muted-foreground">
									<i class="fa-solid fa-pen text-md"></i>
								</button>
							</div>
						</div>
					</div>

					<button type="button" wire:click="submitWithdrawalRequest" wire:loading.attr="disabled"
						wire:target="submitWithdrawalRequest"
						class="mt-auto w-full rounded-full bg-[#2CB34A] px-4 py-2 text-sm font-bold uppercase tracking-wide text-white disabled:opacity-70">
						<span wire:loading.remove wire:target="submitWithdrawalRequest"
							class="inline-flex items-center gap-4">{{ __('Withdraw') }} <i class="fa-solid fa-arrow-right"></i></span>
						<span wire:loading wire:target="submitWithdrawalRequest" class="inline-flex items-center gap-2">
							<i class="fa-solid fa-spinner animate-spin text-sm"></i>
							{{ __('Submitting...') }}
						</span>
					</button>
				</div>
			@else
				<div class="space-y-4">
					<div class="bg-card rounded-2xl border border-border p-4 space-y-4">
						<div class="flex items-center gap-6 text-muted-foreground">
							<span class="inline-flex items-center gap-1 text-green-600"><i
									class="fa-solid fa-shield"></i>{{ __('Secure Withdrawals') }}</span>
							<span class="inline-flex items-center gap-1 text-amber-500"><i
									class="fa-solid fa-bolt"></i>{{ __('Fast Processing') }}</span>
						</div>

						<div class="rounded-2xl border border-border bg-background p-4 space-y-4">
							<p class="text-sm font-semibold text-foreground">{{ __('Withdrawal Summary') }}</p>
							<p class="text-sm text-muted-foreground">{{ __('Bank Name') }}: {{ $bankName }}</p>
							<p class="text-sm text-muted-foreground">{{ __('Account Number') }}: {{ $bankAccountNumber }}</p>
							<p class="text-sm text-muted-foreground">{{ __('Account Holder') }}: {{ $bankAccountHolderName }}</p>
							<div class="border-t border-border pt-4 flex items-center justify-between gap-3">
								<p class="text-sm text-muted-foreground">{{ __('Withdrawal Amount') }}</p>
								<p class="text-sm font-semibold text-foreground">{{ $this->currencyCode }}
									{{ number_format((float) $withdrawAmount, 2) }}</p>
							</div>
						</div>
					</div>

					<div class="flex gap-2">
						<button type="button" wire:click="backToDetails"
							class="flex-1 rounded-xl border border-border bg-background px-4 py-2.5 text-sm font-semibold text-foreground">
							{{ __('Back') }}
						</button>
						<button type="button" wire:click="submitWithdrawalRequest" wire:loading.attr="disabled"
							wire:target="submitWithdrawalRequest"
							class="flex-1 rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-white disabled:opacity-70">
							<span wire:loading.remove wire:target="submitWithdrawalRequest">{{ __('Confirm Withdrawal') }}</span>
							<span wire:loading wire:target="submitWithdrawalRequest" class="inline-flex items-center gap-2">
								<i class="fa-solid fa-spinner animate-spin text-sm"></i>
								{{ __('Submitting...') }}
							</span>
						</button>
					</div>
				</div>
			@endif
		@else
			@if ($selectedMethod === 'mpesa')
				<div class="min-h-[72vh] flex flex-col">
					<div class="pt-6 space-y-3 text-center">
						<div class="mx-auto size-12 rounded-full bg-[#2CB34A] text-white flex items-center justify-center">
							<i class="fa-solid fa-arrow-up-right-dots text-2xl"></i>
						</div>
						<p class="text-md font-extrabold tracking-wide text-foreground">{{ __('WITHDRAW TO M-PESA') }}</p>
						<p class="text-md font-extrabold tracking-wide text-foreground">
							{{ __('AMOUNT: :currency :amount', ['currency' => $this->currencyCode, 'amount' => number_format($submittedAmount, 2)]) }}
						</p>
						<p class="text-sm uppercase tracking-wide text-muted-foreground">{{ __('TRANSACTION FEE: KSH. 0') }}</p>
					</div>

					<div class="my-auto text-center space-y-6 px-10">
						<div
							class="mx-auto size-12 rounded-full border-4 border-green-600 text-green-600 flex items-center justify-center">
							<i class="fa-solid fa-check text-2xl"></i>
						</div>
						<p class="text-md font-medium text-green-600">
							{{ __('Your request to withdraw has been received. Kindly wait for confirmation') }}
						</p>
					</div>

					<button type="button" wire:click="finishFlow"
						class="mt-1 w-full rounded-md bg-[#2CB34A] px-4 py-2 text-sm font-extrabold uppercase tracking-wide text-white">
						{{ __('Done') }}
					</button>
				</div>
			@else
				<div class="bg-card rounded-[24px] border border-border p-5 min-h-[70vh] flex flex-col">
					<div class="pt-8 space-y-4 text-center">
						<div class="mx-auto size-12 rounded-full bg-green-600/15 text-green-600 flex items-center justify-center">
							<i class="fa-solid fa-check text-2xl"></i>
						</div>
						<p class="text-sm font-extrabold text-foreground">{{ __('Withdrawal Submitted!') }}</p>
						<p class="text-md text-muted-foreground">
							{{ __('Your withdrawal request has been submitted and is being processed.') }}
						</p>
					</div>

					<div class="my-auto rounded-1xl border border-border bg-background p-4 text-center">
						<p class="text-sm text-muted-foreground">{{ __('Amount') }}</p>
						<p class="text-sm font-bold text-foreground">{{ $this->currencyCode }} {{ number_format($submittedAmount, 2) }}
						</p>
					</div>

					<button type="button" wire:click="finishFlow"
						class="mt-1 w-full rounded-md bg-[#2CB34A] px-4 py-2 text-sm font-semibold text-white">
						{{ __('Done') }}
					</button>
				</div>
			@endif
		@endif
	</div>
</div>