<?php
use App\Models\Investment;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Mail\WalletTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\MemberNotificationService;
use App\Services\Vrm\InvestmentEmailService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Investment Portfolio') }}</x-slot>
        <x-slot name="desc">{{ __('Review member package subscriptions, gain progress, and maturity status.') }}</x-slot>

        {!! $this->renderNotification() !!}

        <div class="mb-4 grid gap-4 md:grid-cols-2">
            <div>
                <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Status Filter') }}</label>
                <select wire:model.live="status"
                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                    <option value="all">{{ __('All') }}</option>
                    <option value="active">{{ __('Active') }}</option>
                    <option value="claimed">{{ __('Claimed') }}</option>
                    <option value="cancelled">{{ __('Cancelled') }}</option>
                    <option value="failed">{{ __('Failed') }}</option>
                </select>
            </div>
            <div>
                <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Search Member') }}</label>
                <input type="text" wire:model.live.debounce.300ms="search"
                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"
                    placeholder="{{ __('Search by member name or email...') }}" />
            </div>
        </div>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Member') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Package') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Principal') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Expected') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Accrued') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Progress') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                        <th class="py-3.5 pr-4 pl-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Matures') }}</th>
                        <th class="py-3.5 pr-4 pl-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    @forelse ($this->investments as $investment)
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">
                                <p class="font-semibold">{{ $investment->user?->name ?? '-' }}</p>
                                <p class="text-xs text-gray-500">{{ $investment->user?->email ?? '-' }}</p>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $investment->package?->name ?? '-' }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $this->currencyCode }} {{ number_format((float) $investment->principal_amount, 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $this->currencyCode }} {{ number_format((float) $investment->expected_return_amount, 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $this->currencyCode }} {{ number_format((float) $investment->accrued_amount, 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                <div class="w-40">
                                    <div class="h-2 rounded bg-gray-200 dark:bg-gray-700">
                                        <div class="h-2 rounded bg-indigo-500" style="width: {{ max(0, min(100, (int) round($investment->progress_ratio * 100))) }}%"></div>
                                    </div>
                                    <p class="mt-1 text-xs text-gray-500">{{ number_format($investment->progress_ratio * 100, 1) }}%</p>
                                </div>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ ucfirst($investment->status) }}</td>
                            <td class="py-4 pr-4 pl-3 text-sm text-gray-500 dark:text-gray-400">{{ $investment->matures_at?->format('M j, Y g:i A') ?? '-' }}</td>
                            <td class="py-4 pr-4 pl-3 text-sm text-gray-500 dark:text-gray-400">
                                @if ($investment->is_active)
                                    <div class="flex w-64 flex-col gap-2">
                                        <div class="flex items-center gap-2">
                                            <input
                                                type="datetime-local"
                                                wire:model="maturityInputs.{{ $investment->id }}"
                                                value="{{ ($maturityInputs[$investment->id] ?? $investment->matures_at?->format('Y-m-d\\TH:i')) }}"
                                                class="block w-full rounded-md border border-gray-300 bg-white px-2 py-1 text-xs text-gray-900 outline-none focus:border-indigo-500 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100"
                                            />
                                            <button type="button" wire:click="updateMaturity({{ $investment->id }})"
                                                class="rounded bg-gray-900 px-2 py-1 text-xs font-semibold text-white dark:bg-gray-100 dark:text-gray-900">
                                                {{ __('Save') }}
                                            </button>
                                        </div>
                                        <div class="flex gap-2">
                                            <button type="button" wire:confirm="{{ __('Close this investment as success?') }}" wire:click="closeAsSuccess({{ $investment->id }})"
                                                class="rounded bg-emerald-600 px-2 py-1 text-xs font-semibold text-white">
                                                {{ __('Mark Success') }}
                                            </button>
                                            <button type="button" wire:confirm="{{ __('Close this investment as failure?') }}" wire:click="closeAsFailure({{ $investment->id }})"
                                                class="rounded bg-rose-600 px-2 py-1 text-xs font-semibold text-white">
                                                {{ __('Mark Failure') }}
                                            </button>
                                        </div>
                                    </div>
                                @else
                                    <span class="text-xs text-gray-400">{{ __('Closed') }}</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No investments found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">{{ $this->investments->links() }}</div>
    </x-admin-panel>
</div>