<?php
use App\Facades\Vrm\MediaForge;
use App\Models\Security;
use App\Models\SecurityLog;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Edit Security') }}</x-slot>
        <x-slot name="desc">{{ __('Update security details and manually add price history logs.') }}</x-slot>
        <x-slot name="button">
            <a href="{{ route('admin.securities.index') }}"
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                {{ __('Go Back') }}
            </a>
        </x-slot>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-5 mb-5 sm:p-6">
            {!! $this->renderNotification() !!}

            <form wire:submit="save" class="space-y-6">
                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Ticker Name') }}</label>
                        <input type="text" wire:model="trading_name"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('trading_name') }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Display Name') }}</label>
                        <input type="text" wire:model="name"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('name') }}</span>
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Logo') }}</label>
                        <input type="file" wire:model="logo" accept=".jpg,.jpeg,.png,.webp"
                            class="mt-1 block w-full cursor-pointer px-3 py-2 text-sm file:mr-4 file:rounded-md file:border-0 file:bg-gray-200 dark:file:bg-gray-600 file:px-3 file:py-1.5 file:text-sm file:font-semibold file:text-gray-900 dark:file:text-gray-100 hover:file:bg-gray-300 dark:hover:file:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2" />
                        <span class="text-red-500 text-sm">{{ $errors->first('logo') }}</span>

                        @if ($logo)
                            <img src="{{ $logo->temporaryUrl() }}" class="mt-2 h-16 w-16 rounded object-cover" alt="preview" />
                        @elseif ($currentLogo)
                            <div class="mt-2 flex items-center gap-4">
                                <img src="{{ asset($currentLogo) }}" class="h-16 w-16 rounded object-cover" alt="current logo" />
                                <button type="button" wire:click="removeCurrentLogo" class="rounded-md bg-red-600 px-3 py-1 text-xs font-semibold text-white hover:bg-red-500">{{ __('Remove') }}</button>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Currency Code') }}</label>
                        <input type="text" wire:model="currency_code"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base uppercase text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('currency_code') }}</span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Current Price') }}</label>
                        <input type="number" step="0.0001" min="0.0001" wire:model="current_amount"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('current_amount') }}</span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Initial Listing Price') }}</label>
                        <input type="number" step="0.0001" min="0.0001" wire:model="initial_listing_amount"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('initial_listing_amount') }}</span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Min Shares') }}</label>
                        <input type="number" step="1" min="1" wire:model="min_shares"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('min_shares') }}</span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Max Shares Per Purchase (0 = unlimited)') }}</label>
                        <input type="number" step="1" min="0" wire:model="max_shares_purchase"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('max_shares_purchase') }}</span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Max Shares Holding (0 = unlimited)') }}</label>
                        <input type="number" step="1" min="0" wire:model="max_shares_holding"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('max_shares_holding') }}</span>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Description') }}</label>
                    <textarea wire:model="description" rows="4"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"></textarea>
                    <span class="text-red-500 text-sm">{{ $errors->first('description') }}</span>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white hover:bg-indigo-500">
                        {{ __('Save Changes') }}
                    </button>
                </div>
            </form>
        </div>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-5 mb-5 sm:p-6">
            <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">{{ __('Price History Log') }}</h3>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-300">{{ __('Append manual logs and keep latest price in sync across the system.') }}</p>

            <form wire:submit="addPriceLog" class="mt-4 grid grid-cols-1 gap-4 md:grid-cols-4">
                <div>
                    <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Price') }}</label>
                    <input type="number" step="0.0001" min="0.0001" wire:model="log_price"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                    <span class="text-red-500 text-sm">{{ $errors->first('log_price') }}</span>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Change % (optional)') }}</label>
                    <input type="number" step="0.0001" wire:model="log_change_percent"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                    <span class="text-red-500 text-sm">{{ $errors->first('log_change_percent') }}</span>
                </div>

                <div>
                    <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Source') }}</label>
                    <select wire:model="log_source"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <option value="manual">{{ __('manual') }}</option>
                        <option value="system">{{ __('system') }}</option>
                        <option value="api">{{ __('api') }}</option>
                    </select>
                    <span class="text-red-500 text-sm">{{ $errors->first('log_source') }}</span>
                </div>

                <div class="flex items-end">
                    <button type="submit" class="w-full rounded-md bg-emerald-600 px-4 py-2 text-sm font-semibold text-white hover:bg-emerald-500">
                        {{ __('Add Log') }}
                    </button>
                </div>
            </form>

            <div class="mt-6 overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Logged At') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Before') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Now') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Change %') }}</th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Source') }}</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800">
                        @php($logs = $this->logs->values())
                        @forelse ($logs as $index => $log)
                            @php($beforeLog = $logs->get($index + 1))
                            <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                                <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ optional($log->logged_at)->format('Y-m-d H:i') ?: '-' }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                    {{ $beforeLog ? number_format((float) $beforeLog->price, 4) : '-' }}
                                </td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ number_format((float) $log->price, 4) }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ number_format((float) $log->change_percent, 4) }}</td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $log->source }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No logs yet.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </x-admin-panel>
</div>