<?php

use Illuminate\Support\Facades\Http;

beforeEach(function () {
    config([
        'services.rapidapi_nse.host' => 'nairobi-stock-exchange-nse.p.rapidapi.com',
        'services.rapidapi_nse.key' => 'test-key',
    ]);
});

test('stocks index returns list from LiveStockService', function () {
    $payload = [['symbol' => 'Safaricom'], ['symbol' => 'KCB']];

    Http::fake([
        'https://nairobi-stock-exchange-nse.p.rapidapi.com/stocks' => Http::response($payload, 200),
    ]);

    $response = $this->getJson('/api/v1/stocks');

    $response->assertOk()
        ->assertJsonPath('success', true)
        ->assertJsonPath('data', $payload);
});

test('stocks index returns error on API failure', function () {
    Http::fake([
        'https://nairobi-stock-exchange-nse.p.rapidapi.com/stocks' => Http::response(['error' => 'Server error'], 502),
    ]);

    $response = $this->getJson('/api/v1/stocks');

    $response->assertStatus(502)
        ->assertJsonPath('success', false);
});
