<?php

use App\Services\RapidNSE;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Http;

beforeEach(function () {
    config([
        'services.rapidapi_nse.host' => 'nairobi-stock-exchange-nse.p.rapidapi.com',
        'services.rapidapi_nse.key' => 'test-key',
    ]);
});

test('getStocks returns decoded JSON on successful response', function () {
    $payload = [['symbol' => 'Safaricom'], ['symbol' => 'KCB']];

    Http::fake([
        'https://nairobi-stock-exchange-nse.p.rapidapi.com/stocks' => Http::response($payload, 200),
    ]);

    $service = app(RapidNSE::class);
    $result = $service->getStocks();

    expect($result)->toBe($payload);
});

test('getStock returns decoded JSON on successful response', function () {
    $payload = ['symbol' => 'Safaricom', 'price' => 15.50];

    Http::fake([
        'https://nairobi-stock-exchange-nse.p.rapidapi.com/stocks/*' => Http::response($payload, 200),
    ]);

    $service = app(RapidNSE::class);
    $result = $service->getStock('Safaricom');

    expect($result)->toBe($payload);
});

test('getStock throws RequestException on failed response', function () {
    Http::fake([
        'https://nairobi-stock-exchange-nse.p.rapidapi.com/stocks/*' => Http::response(['error' => 'Not found'], 404),
    ]);

    $service = app(RapidNSE::class);

    $service->getStock('InvalidSymbol');
})->throws(RequestException::class);
