<?php

use App\Models\Security;
use App\Models\SecurityOrder;
use App\Models\User;
use App\Models\Vrm\Role;
use App\Models\Vrm\Utility;
use App\Models\Wallet;
use Livewire\Livewire;

function ensureRoleForMarketControl(int $id, string $name, string $slug): Role
{
    return Role::query()->firstOrCreate(
        ['id' => $id],
        [
            'name' => $name,
            'slug' => $slug,
            'module' => 'Dashboard',
            'authority' => $slug,
            'is_active' => true,
            'description' => $name,
        ]
    );
}

test('member cannot place trade order when market is closed by admin setting', function () {
    Utility::query()->updateOrCreate(
        ['type' => 'general', 'key' => 'market_open'],
        ['value' => '0']
    );

    $memberRole = ensureRoleForMarketControl(3, 'Member', 'member');

    $member = User::factory()->create();
    $member->roles()->attach($memberRole->id);

    Wallet::query()->create([
        'user_id' => $member->id,
        'currency_code' => 'USD',
        'balance' => 1000,
        'used_amount' => 0,
        'earned_amount' => 0,
    ]);

    $security = Security::query()->create([
        'trading_name' => 'AAPL',
        'description' => 'Apple Inc',
        'is_active' => true,
    ]);

    $this->actingAs($member);

    Livewire::test('front.trade')
        ->set("orderQuantities.{$security->id}", 1)
        ->call('placeOrder', $security->id);

    expect(SecurityOrder::query()->count())->toBe(0);

    $wallet = Wallet::query()->where('user_id', $member->id)->firstOrFail();
    expect((float) $wallet->used_amount)->toBe(0.0);
});
